
(* this module depends on Posix because this module needs to read /dev/urandom *)


module Random = 

  (* returns a random number between 0 and upperbound *)
  let int_below upperbound = 
    let buf = String.build 8 in 
    let fd = Posix.open "/dev/urandom" [| Posix.O_RDONLY |] in 
    let _ = Posix.read fd buf 0 8 in 
    let _ = Posix.close fd in 
    let random_number = ((int_of_char buf.[0]) lsl 7) lor 
                        ((int_of_char buf.[1]) lsl 6) lor 
                        ((int_of_char buf.[2]) lsl 5) lor 
                        ((int_of_char buf.[3]) lsl 4) lor 
                        ((int_of_char buf.[4]) lsl 3) lor 
                        ((int_of_char buf.[5]) lsl 2) lor 
                        ((int_of_char buf.[6]) lsl 1) lor 
                        ((int_of_char buf.[7]) lsl 0) in 
    random_number mod upperbound


endmodule
